#!/bin/sh

domainName=$1
interval=$2

#echo domainName = $domainName
#echo interval = $interval

#timeZone=`date +%Z`
#echo timeZone = $timeZone

dateString=`/usr/local/bin/certbot certificates -d $domainName 2>/dev/null | grep 'Expiry Date' | sed 's/^.*Expiry Date: // ; s/+.*$//'`
#echo expiryDateString = $dateString

expiryDate=`TZ=GMT date -j -f '%Y-%m-%d %H:%M:%S' "$dateString"`
#echo expiryDate = $expiryDate

subtractSeconds=''
seconds=''
if ( test $interval -gt 1000 ) then
    seconds=`expr 24 '*' 3600 - $interval`
    interval=1
    subtractSeconds="-v-$seconds"S
fi
#echo subtractSeconds = $subtractSeconds

subtract=`expr 90 - $interval`
#echo subtract = $subtract

renewalDateString=`TZ=GMT date -j -f '%Y-%m-%d %H:%M:%S' -v-"$subtract"d  $subtractSeconds "$dateString"`
#echo renewalDateString = $renewalDateString

      renewalDateActual=`TZ=GMT date -j -f '%Y-%m-%d %H:%M:%S' -v-"$subtract"d  $subtractSeconds "$dateString"`
#echo renewalDate = $renewalDateActual

      renewalDate=`TZ=GMT date -j -f '%Y-%m-%d %H:%M:%S' -v-"$subtract"d  $subtractSeconds "$dateString" +%s`
#echo renewalDate in secs = $renewalDate

        todayDate=`TZ=GMT date +%s`
#echo __todayDate in secs = $todayDate

if ( test $todayDate -ge $renewalDate ) then
    echo Do Renewal
    /usr/bin/logger -p user.error "Letsencrypt - Do Renewal"
    
    array=()
    for i in apache2
    do
        if (test `/bin/launchctl list | grep com.cutedgesystems.$i | awk '{print $3}'`) then
            /bin/launchctl unload -w /Library/LaunchDaemons/com.cutedgesystems.$i.plist
            array+=($i)
        fi
    done
    
    sleep 3
    
    sudo /usr/local/bin/certbot renew --force-renewal --cert-name $domainName 2>/dev/null
    #echo hello | mail -s "Do Renewal for $domainName" bernard
    
    sleep 2
    
    for i in ${array[*]}
    do
        /bin/launchctl load -w /Library/LaunchDaemons/com.cutedgesystems.$i.plist
    done

    for i in postfix dovecot
    do
        if (test `/bin/launchctl list | grep com.cutedgesystems.$i | awk '{print $3}'`) then
            /bin/launchctl unload -w /Library/LaunchDaemons/com.cutedgesystems.$i.plist
            sleep 3
            /bin/launchctl load -w /Library/LaunchDaemons/com.cutedgesystems.$i.plist
        fi
    done

else
    echo Not yet due for Renewal
    /usr/bin/logger -p user.error "Letsencrypt - Not yet due for Renewal"
fi
